using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace _3zad
{
    internal class Program
    {
        static void QuickSort(int[] niz, int[] h, int l, int d)
        {
            if (l < d)
            {
                int i = l, j = d;
                int pivot = niz[(l + d) / 2];

                while (i <= j)
                {
                    while (niz[i] < pivot) i++;
                    while (niz[j] > pivot) j--;

                    if (i <= j)
                    {
                        int temp = niz[i];
                        niz[i] = niz[j];
                        niz[j] = temp;

                        temp = h[i];
                        h[i] = h[j];
                        h[j] = temp;

                        i++;
                        j--;
                    }
                }

                QuickSort(niz, h, l, j);
                QuickSort(niz, h, i, d);
            }
        }

        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            int[] x = new int[n];
            int[] h = new int[n];
            string[] s = Console.ReadLine().Split(' ');
            for (int i = 0; i < n; i++)
            {
                x[i] = int.Parse(s[i]);
            }
            s = Console.ReadLine().Split();
            for (int i = 0; i < n; i++)
            {
                h[i] = int.Parse(s[i]);
            }
            QuickSort(x, h, 0, n - 1);
            double dmin = -1;
            for (int i = 0; i < n; i++)
            {
                dmin = -1;
                for (int j = 0; j < n - 1; j++)
                {
                    double x1 = x[j]; double y1 = h[j];
                    double x2 = x[j + 1]; double y2 = h[j + 1];
                    double xp = (x1 +x2 + y1 - y2) / 2.0;
                    double yp = y1 - (xp - x1);
                    if (h[i] >= Math.Max(y1, y2) || h[i] < yp) continue;
                    if (y1 < y2)
                    {
                            if (h[i] >= y1 || x[i] >= x2)
                            {
                                Double X = (xp - yp) + h[i];
                                if (X >= xp && X <= x2)
                                {
                                    double d = Math.Abs(X - x[i]);
                                    if (dmin < 0 || d < dmin) dmin = d;
                                }
                            }
                            else 
                            {
                                 Double X = (xp + yp) - h[i];
                                 if (x1 <= X && X <= xp)
                                 {
                                     double d = Math.Abs(X - x[i]);
                                     if (dmin < 0 || d < dmin) dmin = d;
                                 }
                            }
                    }
                    else
                    {
                        if (h[i] >= y2 || x[i] <= x1)
                        {
                            Double X = (xp + yp) - h[i];
                            if (x1 <= X && X <= xp)
                            {
                                double d = Math.Abs(X - x[i]);
                                if (dmin < 0 || d < dmin) dmin = d;
                            }
                        }
                        else
                        {
                            Double X = (xp - yp) + h[i];
                            if (X >= xp && X <= x2)
                            {
                                double d = Math.Abs(X - x[i]);
                                if (dmin < 0 || d < dmin) dmin = d;
                            }
                        }
                    }
                }
                if (dmin < 0) Console.WriteLine(-1);
                else Console.WriteLine(dmin);
            }
            Console.ReadLine();
        }
    }
}